/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.block;

import java.util.Random;
import net.jayjay.dangerzone.block.Block;
import net.jayjay.dangerzone.block.Blocks;
import net.jayjay.dangerzone.phys.AABB;
import net.jayjay.dangerzone.render.Tesselator;
import net.jayjay.dangerzone.world.World;

public class BlockPlant
extends Block {
    protected BlockPlant(String tag, int tex) {
        super(tag, tex);
        this.breaksound = "dz2:shatter";
        this.material = "dz2:material_plant";
    }

    @Override
    public void tick(World level, int x, int y, int z, Random random) {
        int below = level.getBlock(x, y - 1, z);
        if (!level.isLit(x, y, z) || below != Blocks.getBlockID("dz2:dirt") && below != Blocks.getBlockID("dz2:grass")) {
            level.setBlock(x, y, z, 0);
        }
    }

    @Override
    public void render(Tesselator t, World level, int layer, int x, int y, int z) {
        if (!(level.isLit(x, y, z) ^ layer != 1)) {
            int tex = this.getTexture(this.tex);
            float u0 = (float)(tex % 16) / 16.0f;
            float u1 = u0 + 0.0624375f;
            float v0 = (float)(tex / 16) / 16.0f;
            float v1 = v0 + 0.0624375f;
            int rots = 2;
            t.setColor(1.0f, 1.0f, 1.0f);
            int r = 0;
            while (r < rots) {
                float xa = (float)(Math.sin((double)r * Math.PI / (double)rots + 0.7853981633974483) * 0.55);
                float za = (float)(Math.cos((double)r * Math.PI / (double)rots + 0.7853981633974483) * 0.55);
                float x0 = (float)x + 0.5f - xa;
                float x1 = (float)x + 0.5f + xa;
                float y0 = (float)y + 0.0f;
                float y1 = (float)y + 1.0f;
                float z0 = (float)z + 0.5f - za;
                float z1 = (float)z + 0.5f + za;
                t.addVertexWithUV(x0, y1, z0, u1, v0);
                t.addVertexWithUV(x1, y1, z1, u0, v0);
                t.addVertexWithUV(x1, y0, z1, u0, v1);
                t.addVertexWithUV(x0, y0, z0, u1, v1);
                t.addVertexWithUV(x1, y1, z1, u0, v0);
                t.addVertexWithUV(x0, y1, z0, u1, v0);
                t.addVertexWithUV(x0, y0, z0, u1, v1);
                t.addVertexWithUV(x1, y0, z1, u0, v1);
                ++r;
            }
        }
    }

    @Override
    public AABB getAABB(int x, int y, int z) {
        return null;
    }

    @Override
    public boolean isPlant() {
        return true;
    }

    @Override
    public boolean hasCustomModel() {
        return true;
    }

    @Override
    public boolean blocksLight() {
        return false;
    }

    @Override
    public boolean isSolid() {
        return false;
    }
}

